using System;
using UnityEngine;

public class Cursor : MonoBehaviour
{
    public HeadShift HeadShift; 

    GameObject _hitObject;

    void Update()
    {
        Ray cursorRay = HeadShift.CursorRay;

        if(Physics.Raycast(cursorRay, out RaycastHit hit,Mathf.Infinity))
        {
            if(_hitObject != hit.transform.gameObject)
            {
                if(_hitObject) _hitObject.GetComponent<Renderer>().material.color = Color.white;

                _hitObject = hit.transform.gameObject;
                _hitObject.GetComponent<Renderer>().material.color = Color.green;
            }
        }
        else
        {
            if(_hitObject)
            {
                _hitObject.GetComponent<Renderer>().material.color = Color.white;
                _hitObject = null;
            }
        }

        transform.position = cursorRay.origin + cursorRay.direction * 3f;
    }
}
